﻿// Listing 9-10

public class SelectionSortAlgorithm
{
   // Uwaga: To nie jest kompletny program.
   //
   //   Metoda selectionSort sortuje tablicę liczb całkowitych
   //   za pomocą algorytmu sortowania przez wybieranie.
   //   Tablica zostaje posortowana w kolejności malejącej.

   public static void selectionSort(int[] array)
   {
      int startScan;   // Początkowa pozycja skanowania
      int index;       // Przechowuje aktualny indeks
      int minIndex;    // Element o najmniejszej wartości w danym skanowaniu
      int minValue;    // Najmniejsza wartość znaleziona w tym skanowaniu

      // Zewnętrzna pętla iteruje po każdym elemencie tablicy.
      // Zmienna startScan wyznacza pozycję, od której ma się
      // rozpocząć skanowanie.
      for (startScan = 0; startScan < (array.length−1); startScan++)
      {
         // Zakładamy, że pierwszy element w skanowanym obszarze
         // ma najmniejszą wartość.
         minIndex = startScan;
         minValue = array[startScan];
         
         // Skanujemy tablicę zaczynając od drugiego elementu 
         // w skanowanym obszarze. Poszukujemy w nim elementu
         // o najmniejszej wartości.
         for(index = startScan + 1; index < array.length; index++)
         {
            if (array[index] < minValue)
            {
               minValue = array[index];
               minIndex = index;
            }
         }

         // Zamieniamy element o najmniejszej wartości 
         // z pierwszym elementem skanowanego obszaru.
         array[minIndex] = array[startScan];
         array[startScan] = minValue;
      }
   }
}
